local assets =
{
    Asset("PKGREF", "sound/dontstarve.fev"),
    Asset("SOUNDPACKAGE", "sound/dontstarve_DLC001.fev"),
    Asset("FILE", "sound/DLC_music.fsb"),
    Asset("SOUNDPACKAGE", "sound/turnoftides.fev"),
    Asset("FILE", "sound/turnoftides.fsb"),
    Asset("SOUNDPACKAGE", "sound/saltydog.fev"),
    Asset("FILE", "sound/saltydog.fsb"),
    Asset("SOUNDPACKAGE", "sound/hookline.fev"),
    Asset("FILE", "sound/hookline.fsb"),
    Asset("SOUNDPACKAGE", "sound/hookline_2.fev"),
    Asset("FILE", "sound/hookline_2.fsb"),

    Asset("SOUNDPACKAGE", "sound/wes.fev"),
    Asset("FILE", "sound/wes.fsb"),

    Asset("SOUNDPACKAGE", "sound/grotto.fev"),
    Asset("FILE", "sound/grotto_sfx.fsb"),
    Asset("FILE", "sound/grotto_amb.fsb"),

    Asset("SOUNDPACKAGE", "sound/moonstorm.fev"),
    Asset("FILE", "sound/moonstorm.fsb"),
    Asset("FILE", "sound/moonstorm.fsb"),

    Asset("SOUNDPACKAGE", "sound/dangerous_sea.fev"),
    Asset("FILE", "sound/dangerous_sea.fsb"),

    Asset("SOUNDPACKAGE", "sound/yotc_2020.fev"),
    Asset("FILE", "sound/yotc_2020.fsb"),

    Asset("SOUNDPACKAGE", "sound/farming.fev"),
    Asset("FILE", "sound/farming.fsb"),

    Asset("SOUNDPACKAGE", "sound/yotb_2021.fev"),
    Asset("FILE", "sound/yotb_2021.fsb"),

    Asset("SOUNDPACKAGE", "sound/wintersfeast2019.fev"),
    Asset("FILE", "sound/wintersfeast2019.fsb"),

    Asset("SOUNDPACKAGE", "sound/summerevent.fev"),
    Asset("FILE", "sound/summerevent.fsb"),
    Asset("SOUNDPACKAGE", "sound/summerevent2022.fev"),
    Asset("FILE", "sound/summerevent2022.fsb"),
    Asset("FILE", "sound/summerevent_music.fsb"),


    Asset("SOUNDPACKAGE", "sound/webber2.fev"),
    Asset("FILE", "sound/webber2.fsb"),

    Asset("SOUNDPACKAGE", "sound/webber1.fev"),
    Asset("FILE", "sound/webber1.fsb"),

    Asset("SOUNDPACKAGE", "sound/waterlogged2.fev"),
    Asset("FILE", "sound/waterlogged2.fsb"),
    Asset("FILE", "sound/waterlogged2_amb.fsb"),

    Asset("SOUNDPACKAGE", "sound/waterlogged1.fev"),
    Asset("FILE", "sound/waterlogged1.fsb"),
    Asset("FILE", "sound/waterlogged1_amb.fsb"),
    

    Asset("SOUNDPACKAGE", "sound/wanda2.fev"),
    Asset("FILE", "sound/wanda2.fsb"),

    Asset("SOUNDPACKAGE", "sound/wanda1.fev"),
    Asset("FILE", "sound/wanda1.fsb"),

    Asset("SOUNDPACKAGE", "sound/terraria1.fev"),
    Asset("FILE", "sound/terraria1.fsb"),

    Asset("SOUNDPACKAGE", "sound/wolfgang2.fev"),
    Asset("FILE", "sound/wolfgang2.fsb"),

    Asset("SOUNDPACKAGE", "sound/wolfgang1.fev"),
    Asset("FILE", "sound/wolfgang1.fsb"),
    
    Asset("SOUNDPACKAGE", "sound/yotc_2022_2.fev"),
    Asset("FILE", "sound/yotc_2022_2.fsb"),

    Asset("SOUNDPACKAGE", "sound/yotc_2022_1.fev"),
    Asset("FILE", "sound/yotc_2022_1.fsb"),

    Asset("SOUNDPACKAGE", "sound/yotr_2023.fev"),
    Asset("FILE", "sound/yotr_2023.fsb"),

    Asset("SOUNDPACKAGE", "sound/ancientguardian_rework.fev"),
    Asset("FILE", "sound/ancientguardian_rework.fsb"),

    Asset("SOUNDPACKAGE", "sound/WX_rework.fev"),
    Asset("FILE", "sound/WX_rework.fsb"),

    Asset("SOUNDPACKAGE", "sound/monkeyisland.fev"),
    Asset("FILE", "sound/monkeyisland.fsb"),
    Asset("FILE", "sound/monkeyisland_music.fsb"),
    Asset("FILE", "sound/monkeyisland_amb.fsb"),

    Asset("SOUNDPACKAGE", "sound/wickerbottom_rework.fev"),
    Asset("FILE", "sound/wickerbottom_rework.fsb"),
    --Asset("FILE", "sound/wickerbottom_rework_music.fsb"),

    Asset("SOUNDPACKAGE", "sound/skin_sfx.fev"),
    Asset("FILE", "sound/skin_sfx.fsb"), 

    Asset("SOUNDPACKAGE", "sound/stageplay_set.fev"),
    Asset("FILE", "sound/stageplay_set.fsb"),
    Asset("FILE", "sound/stageplay_set_music.fsb"),

    Asset("SOUNDPACKAGE", "sound/maxwell_rework.fev"),
    Asset("FILE", "sound/maxwell_rework.fsb"),

    Asset("SOUNDPACKAGE", "sound/daywalker.fev"),
    Asset("FILE", "sound/daywalker.fsb"),

    Asset("SOUNDPACKAGE", "sound/wilson_rework.fev"),
    Asset("FILE", "sound/wilson_rework.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts.fev"),
    Asset("FILE", "sound/rifts.fsb"),
    
    Asset("SOUNDPACKAGE", "sound/aqol.fev"),
    Asset("FILE", "sound/aqol.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts2.fev"),
    Asset("FILE", "sound/rifts2.fsb"),

    Asset("SOUNDPACKAGE", "sound/meta2.fev"),
    Asset("FILE", "sound/meta2.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts3.fev"),
    Asset("FILE", "sound/rifts3.fsb"),
    Asset("FILE", "sound/rifts3_AMB.fsb"),

    Asset("SOUNDPACKAGE", "sound/meta3.fev"),
    Asset("FILE", "sound/meta3.fsb"),

    Asset("SOUNDPACKAGE", "sound/yotd2024.fev"),
    Asset("FILE", "sound/yotd2024.fsb"),
    --Asset("FILE", "sound/yotd2024_music.fsb"),

    Asset("SOUNDPACKAGE", "sound/qol1.fev"),
    Asset("FILE", "sound/qol1.fsb"),

    Asset("SOUNDPACKAGE", "sound/meta4.fev"),
    Asset("FILE", "sound/meta4.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts4.fev"),
    Asset("FILE", "sound/rifts4.fsb"),

    Asset("SOUNDPACKAGE", "sound/hallowednights2024.fev"),
    Asset("FILE", "sound/hallowednights2024.fsb"),

    Asset("SOUNDPACKAGE", "sound/meta5.fev"),
    Asset("FILE", "sound/meta5.fsb"),    

    Asset("SOUNDPACKAGE", "sound/balatro.fev"),
    Asset("FILE", "sound/balatro.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts5.fev"),
    Asset("FILE", "sound/rifts5.fsb"),

    Asset("SOUNDPACKAGE", "sound/lunarhail_event.fev"),
    Asset("FILE", "sound/lunarhail_event.fsb"),

    Asset("SOUNDPACKAGE", "sound/rifts6.fev"),
    Asset("FILE", "sound/rifts6.fsb"),

    Asset("SOUNDPACKAGE", "sound/hallowednights2025.fev"),
    Asset("FILE", "sound/hallowednights2025.fsb"),

    Asset("SOUNDPACKAGE", "sound/winter2025.fev"),
    Asset("FILE", "sound/winter2025.fsb"),

    Asset("FILE", "sound/wilton.fsb"),         -- Legacy sound that can be used in mods
    Asset("FILE", "sound/winnie.fsb"),         -- Legacy sound that can be used in mods
    Asset("FILE", "sound/wallace.fsb"),        -- Legacy sound that can be used in mods
    Asset("FILE", "sound/woodrow.fsb"),        -- Legacy sound that can be used in mods
    Asset("FILE", "sound/stuff.fsb"),          -- Legacy sound that can be used in mods

    Asset("FILE", "klump/strings/unused.txt"),         -- Make the klump zip not empty.


    -- Legacy for modders to view. These files are now dynamically loaded.
    Asset("PKGREF", "anim/ghost_wathgrithr_build.zip"),
    Asset("PKGREF", "anim/ghost_waxwell_build.zip"),
    Asset("PKGREF", "anim/ghost_webber_build.zip"),
    Asset("PKGREF", "anim/ghost_wendy_build.zip"),
    Asset("PKGREF", "anim/ghost_werebeaver_build.zip"),
    Asset("PKGREF", "anim/ghost_wes_build.zip"),
    Asset("PKGREF", "anim/ghost_wickerbottom_build.zip"),
    Asset("PKGREF", "anim/ghost_willow_build.zip"),
    Asset("PKGREF", "anim/ghost_wilson_build.zip"),
    Asset("PKGREF", "anim/ghost_winona_build.zip"),
    Asset("PKGREF", "anim/ghost_wolfgang_build.zip"),
    Asset("PKGREF", "anim/ghost_woodie_build.zip"),
    Asset("PKGREF", "anim/ghost_wx78_build.zip"),
    Asset("PKGREF", "anim/wathgrithr.zip"),
    Asset("PKGREF", "anim/waxwell.zip"),
    Asset("PKGREF", "anim/webber.zip"),
    Asset("PKGREF", "anim/wendy.zip"),
    Asset("PKGREF", "anim/werebeaver_build.zip"),
    Asset("PKGREF", "anim/wes.zip"),
    Asset("PKGREF", "anim/wickerbottom.zip"),
    Asset("PKGREF", "anim/willow.zip"),
    Asset("PKGREF", "anim/wilson.zip"),
    Asset("PKGREF", "anim/winona.zip"),
    Asset("PKGREF", "anim/wolfgang.zip"),
    Asset("PKGREF", "anim/wolfgang_mighty.zip"),
    Asset("PKGREF", "anim/wolfgang_skinny.zip"),
    Asset("PKGREF", "anim/woodie.zip"),
    Asset("PKGREF", "anim/wx78.zip"),

    -- Legacy for mods this file is positively dusty.
    Asset("PKGREF", "anim/ui_krampusbag_2x5.zip"),

    -- Core game.
    Asset("ATLAS", "images/global.xml"),
    Asset("IMAGE", "images/global.tex"),
    Asset("IMAGE", "images/visited.tex"),
    Asset("ANIM", "anim/scroll_arrow.zip"),

    Asset("SHADER", "shaders/anim_bloom.ksh"),
    Asset("SHADER", "shaders/anim_bloom_ghost.ksh"),
    Asset("SHADER", "shaders/road.ksh"),

    Asset("IMAGE", "images/shadow.tex"),
    Asset("IMAGE", "images/erosion.tex"),
    Asset("IMAGE", "images/erosion_holo.tex"),
    Asset("IMAGE", "images/circle.tex"),
    Asset("IMAGE", "images/square.tex"),
    Asset("IMAGE", "images/trans.tex"),
    Asset("IMAGE", "images/tree.tex"),

    Asset("DYNAMIC_ATLAS", "images/fepanels.xml"),
    Asset("PKGREF", "images/fepanels.tex"),

    --item explorer stuff in and out of game
    Asset("ANIM", "anim/bolt_of_cloth.zip"),
    Asset("ANIM", "anim/spool.zip"),
    Asset("ANIM", "anim/frame_bg.zip"),
    Asset("ANIM", "anim/accountitem_frame.zip"),
    Asset("ANIM", "anim/frames_comp.zip"), -- If we replace frames_comp with accountitem_frame, we can remove.

    --IAP shop is accessible in FE and in in-game lobby
    Asset("DYNAMIC_ATLAS", "images/fepanels_redux.xml"),
    Asset("PKGREF", "images/fepanels_redux.tex"),

    Asset("DYNAMIC_ANIM", "anim/dynamic/box_shared_spiral.zip"),
    Asset("PKGREF", "anim/dynamic/box_shared_spiral.dyn"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/box_shared.zip"), --needed for the mystery and purchase box opening animation (happens to contain the forge box build too)
    Asset("PKGREF", "anim/dynamic/box_shared.dyn"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/box_bolt.zip"),
    Asset("PKGREF", "anim/dynamic/box_bolt.dyn"),

    -- Used in event join flow and in-game victory.
    Asset("ATLAS", "images/dialogcurly_9slice.xml"),
    Asset("IMAGE", "images/dialogcurly_9slice.tex"),

    -- Used for motd and options
    Asset("ATLAS", "images/dialogrect_9slice.xml"),
    Asset("IMAGE", "images/dialogrect_9slice.tex"),

    Asset("DYNAMIC_ATLAS", "images/lavaarena_achievements.xml"),
    Asset("PKGREF", "images/lavaarena_achievements.tex"),

	Asset("ATLAS", "images/lavaarena_unlocks.xml"),
	Asset("IMAGE", "images/lavaarena_unlocks.tex"),

	Asset("ATLAS", "images/lavaarena_unlocks2.xml"),
	Asset("IMAGE", "images/lavaarena_unlocks2.tex"),

	Asset("ATLAS", "images/lavaarena_quests.xml"),
	Asset("IMAGE", "images/lavaarena_quests.tex"),

    Asset("DYNAMIC_ATLAS", "images/quagmire_food_common_inv_images_hires.xml"),
    Asset("PKGREF", "images/quagmire_food_common_inv_images_hires.tex"),

    Asset("ATLAS", "images/quagmire_achievements.xml"),
    Asset("IMAGE", "images/quagmire_achievements.tex"),

    Asset("ATLAS", "images/quagmire_recipebook.xml"),
    Asset("IMAGE", "images/quagmire_recipebook.tex"),

    Asset("ATLAS", "images/plantregistry.xml"),
    Asset("IMAGE", "images/plantregistry.tex"),

    Asset("ATLAS", "images/scrapbook.xml"),
    Asset("IMAGE", "images/scrapbook.tex"),

    Asset("ATLAS", "images/scrapbook_icons1.xml"),
    Asset("IMAGE", "images/scrapbook_icons1.tex"), 
    Asset("ATLAS", "images/scrapbook_icons2.xml"),
    Asset("IMAGE", "images/scrapbook_icons2.tex"), 
    Asset("ATLAS", "images/scrapbook_icons3.xml"),
    Asset("IMAGE", "images/scrapbook_icons3.tex"),     

    Asset("ATLAS", "images/crafting_menu.xml"),
    Asset("IMAGE", "images/crafting_menu.tex"),
    Asset("ATLAS", "images/crafting_menu_icons.xml"),
    Asset("IMAGE", "images/crafting_menu_icons.tex"),
    Asset("ATLAS", "images/crafting_menu_avatars.xml"),
    Asset("IMAGE", "images/crafting_menu_avatars.tex"),

    Asset("DYNAMIC_ATLAS", "images/options.xml"),
    Asset("PKGREF", "images/options.tex"),
    Asset("DYNAMIC_ATLAS", "images/options_bg.xml"),
    Asset("PKGREF", "images/options_bg.tex"),

    Asset("ATLAS", "images/frontend.xml"),
    Asset("IMAGE", "images/frontend.tex"),
    Asset("ATLAS", "images/frontend_redux.xml"),
    Asset("IMAGE", "images/frontend_redux.tex"),

    Asset("ATLAS", "images/bg_spiral.xml"),
    Asset("IMAGE", "images/bg_spiral.tex"),
    Asset("ATLAS", "images/bg_vignette.xml"),
    Asset("IMAGE", "images/bg_vignette.tex"),
    --Asset("ANIM", "anim/sail_over.zip"), --unused
    Asset("ANIM", "anim/paddle_over.zip"),


    Asset("DYNAMIC_ATLAS", "images/fepanel_fills.xml"),
    Asset("PKGREF", "images/fepanel_fills.tex"),

    Asset("ATLAS", "images/bg_redux_dark_right.xml"),
    Asset("IMAGE", "images/bg_redux_dark_right.tex"),
    Asset("ATLAS", "images/bg_redux_dark_sidebar.xml"),
    Asset("IMAGE", "images/bg_redux_dark_sidebar.tex"),

    -- Old portal frontend background from before The Forge UI update. Still
    -- used on tradescreen.
    --Note(Peter):try moving this to the frontend prefab
    Asset("DYNAMIC_ATLAS", "images/bg_animated_portal.xml"),
    Asset("PKGREF", "images/bg_animated_portal.tex"),
    Asset("DYNAMIC_ATLAS", "images/fg_animated_portal.xml"),
    Asset("PKGREF", "images/fg_animated_portal.tex"),
    Asset("DYNAMIC_ATLAS", "images/fg_trees.xml"),
    Asset("PKGREF", "images/fg_trees.tex"),
    --

    Asset("ANIM", "anim/portal_scene2.zip"),
    Asset("ANIM", "anim/portal_scene_steamfxbg.zip"),
    Asset("ANIM", "anim/portal_scene2_inside.zip"),
    Asset("ANIM", "anim/portal_scene_steamfxeast.zip"),
    Asset("ANIM", "anim/portal_scene_steamfxwest.zip"),
    Asset("ANIM", "anim/portal_scene_steamfxsouth.zip"),
    Asset("ANIM", "anim/cloud_build.zip"),

    --Asset("IMAGE", "images/river_bed.tex"),
    --Asset("IMAGE", "images/water_river.tex"),
    Asset("IMAGE", "images/pathnoise.tex"),
    Asset("IMAGE", "images/mini_pathnoise.tex"),
    Asset("IMAGE", "images/roadnoise.tex"),
    Asset("IMAGE", "images/roadedge.tex"),
    Asset("IMAGE", "images/roadcorner.tex"),
    Asset("IMAGE", "images/roadendcap.tex"),

    --TODO(YOG): Why does this get unloaded a the wrong time if we load it as part of the forest prefab?
    Asset("IMAGE", "images/overlays_lunacy.tex"),

    Asset("ATLAS", "images/overlays_moonstorm.xml"),
    Asset("IMAGE", "images/overlays_moonstorm.tex"),

    Asset("IMAGE", "images/colour_cubes/identity_colourcube.tex"),

    Asset("MINIMAP_IMAGE", "missing_asset"), -- NOTES(JBK): You better fix this if you see it!

    Asset("SHADER", "shaders/anim.ksh"),
    Asset("SHADER", "shaders/anim_fade.ksh"),
    Asset("SHADER", "shaders/anim_bloom.ksh"),
    Asset("SHADER", "shaders/anim_holo.ksh"),

    Asset("SHADER", "shaders/anim_skinned.ksh"),
    Asset("SHADER", "shaders/anim_bloom_skinned.ksh"),

    Asset("SHADER", "shaders/creep.ksh"),
    Asset("SHADER", "shaders/debug_line.ksh"),
    Asset("SHADER", "shaders/debug_tri.ksh"),
    Asset("SHADER", "shaders/render_depth.ksh"),
    Asset("SHADER", "shaders/font.ksh"),
    Asset("SHADER", "shaders/font_packed.ksh"),
    Asset("SHADER", "shaders/font_packed_outline.ksh"),
    Asset("SHADER", "shaders/ground.ksh"),
    Asset("SHADER", "shaders/ground_overlay.ksh"),
    Asset("SHADER", "shaders/ground_lights.ksh"),
    Asset("SHADER", "shaders/ground_underground.ksh"),
	Asset("SHADER", "shaders/ocean.ksh"),
    Asset("SHADER", "shaders/ocean_combined.ksh"),
    Asset("SHADER", "shaders/ceiling.ksh"),
    Asset("SHADER", "shaders/lighting.ksh"),
    Asset("SHADER", "shaders/minimap.ksh"),
    Asset("SHADER", "shaders/minimapocean.ksh"),
    Asset("SHADER", "shaders/minimapfs.ksh"),
    Asset("SHADER", "shaders/particle.ksh"),
    Asset("SHADER", "shaders/vfx_particle.ksh"),
    Asset("SHADER", "shaders/vfx_particle_add.ksh"),
    Asset("SHADER", "shaders/vfx_particle_reveal.ksh"),
    Asset("SHADER", "shaders/road.ksh"),
    Asset("SHADER", "shaders/river.ksh"),
    Asset("SHADER", "shaders/splat.ksh"),
    Asset("SHADER", "shaders/sprite.ksh"),
    Asset("SHADER", "shaders/texture.ksh"),
    Asset("SHADER", "shaders/ui.ksh"),
    Asset("SHADER", "shaders/ui_cc.ksh"),
    Asset("SHADER", "shaders/ui_yuv.ksh"),
    Asset("SHADER", "shaders/swipe_fade.ksh"),
    Asset("SHADER", "shaders/ui_anim.ksh"),
    Asset("SHADER", "shaders/ui_anim_holo.ksh"),
    Asset("SHADER", "shaders/ui_anim_cc.ksh"),
	Asset("SHADER", "shaders/shade.ksh"),

    Asset("SHADER", "shaders/blurh.ksh"),
    Asset("SHADER", "shaders/blurv.ksh"),
    Asset("SHADER", "shaders/combine_colour_cubes.ksh"),
    Asset("SHADER", "shaders/postprocess_none.ksh"),
    Asset("SHADER", "shaders/postprocess_bloom.ksh"),
    Asset("SHADER", "shaders/postprocess_colourcube.ksh"),
    Asset("SHADER", "shaders/postprocess_distort.ksh"),
    Asset("SHADER", "shaders/postprocess_lunacy.ksh"),
    Asset("SHADER", "shaders/postprocess_moonpulse.ksh"),
    Asset("SHADER", "shaders/postprocess_moonpulsegrading.ksh"),
    Asset("SHADER", "shaders/postprocess_zoomblur.ksh"),

	Asset("SHADER", "shaders/blendoceantexture.ksh"),
    Asset("SHADER", "shaders/waterfall2.ksh"),

    Asset("SHADER", "shaders/waves.ksh"),
    Asset("SHADER", "shaders/overheat.ksh"),
    Asset("SHADER", "shaders/moonstorm.ksh", 1), --1 to indicate do a fallback if needed
    Asset("PKGREF", "shaders/moonstorm_fallback.ksh" ),
    Asset("SHADER", "shaders/moonstorm_goggles.ksh", 1), --1 to indicate do a fallback if needed
    Asset("PKGREF", "shaders/moonstorm_goggles_fallback.ksh" ),

    Asset("SHADER", "shaders/anim_haunted.ksh"),
    Asset("SHADER", "shaders/anim_fade_haunted.ksh"),
    Asset("SHADER", "shaders/anim_bloom_haunted.ksh"),
    Asset("SHADER", "shaders/minimapblend.ksh"),

    --common UI elements that we will always need
    Asset("ATLAS", "images/ui.xml"),
    Asset("IMAGE", "images/ui.tex"),
    Asset("ATLAS", "images/global_redux.xml"),
    Asset("IMAGE", "images/global_redux.tex"),
    Asset("ATLAS", "images/textboxes.xml"),
    Asset("IMAGE", "images/textboxes.tex"),
    Asset("ATLAS", "images/scoreboard.xml"),
    Asset("IMAGE", "images/scoreboard.tex"),
    Asset("ANIM", "anim/generating_world.zip"),
    Asset("ANIM", "anim/generating_forest.zip"),
    Asset("ANIM", "anim/generating_cave.zip"),
    Asset("ANIM", "anim/creepy_hands.zip"),
    Asset("ANIM", "anim/saving_indicator.zip"),
    Asset("ANIM", "anim/cookbook_newrecipe.zip"),

    Asset("ANIM", "anim/skingift_popup.zip"),
    Asset("ATLAS", "images/giftpopup.xml"),
    Asset("IMAGE", "images/giftpopup.tex"),

    --Used in the FE and BG
    Asset("DYNAMIC_ATLAS", "images/inventoryimages.xml"),--legacy for mods
    Asset("PKGREF", "images/inventoryimages.tex"),
    Asset("ATLAS", "images/inventoryimages1.xml"),
    Asset("IMAGE", "images/inventoryimages1.tex"),
    Asset("ATLAS", "images/inventoryimages2.xml"),
    Asset("IMAGE", "images/inventoryimages2.tex"),
    Asset("ATLAS", "images/inventoryimages3.xml"),
    Asset("IMAGE", "images/inventoryimages3.tex"),
    Asset("ATLAS", "images/inventoryimages4.xml"),
    Asset("IMAGE", "images/inventoryimages4.tex"),

    Asset("ATLAS", "images/hud.xml"),
    Asset("IMAGE", "images/hud.tex"),
    Asset("ATLAS", "images/hud2.xml"),
    Asset("IMAGE", "images/hud2.tex"),

    Asset("ATLAS", "images/skilltree.xml"),
    Asset("IMAGE", "images/skilltree.tex"),

    Asset("ATLAS", "images/skilltree2.xml"),
    Asset("IMAGE", "images/skilltree2.tex"),

    Asset("ATLAS", "images/skilltree3.xml"),
    Asset("IMAGE", "images/skilltree3.tex"),

    Asset("ATLAS", "images/skilltree4.xml"),
    Asset("IMAGE", "images/skilltree4.tex"),

    Asset("ATLAS", "images/skilltree5.xml"),
    Asset("IMAGE", "images/skilltree5.tex"),

    Asset("ATLAS", "images/skilltree_icons.xml"),
    Asset("IMAGE", "images/skilltree_icons.tex"),    

    Asset("ATLAS", "images/customisation.xml"),
    Asset("IMAGE", "images/customisation.tex"), 

    --oft-used panel bgs
    Asset("DYNAMIC_ATLAS", "images/globalpanels2.xml"),
    Asset("PKGREF", "images/globalpanels2.tex"),

    Asset("ATLAS", "images/button_icons.xml"),
    Asset("IMAGE", "images/button_icons.tex"),
    Asset("ATLAS", "images/button_icons2.xml"),
    Asset("IMAGE", "images/button_icons2.tex"),

    Asset("ATLAS", "images/avatars.xml"),
    Asset("IMAGE", "images/avatars.tex"),

    Asset("ATLAS", "images/profileflair.xml"),
    Asset("IMAGE", "images/profileflair.tex"),

    Asset("ATLAS", "images/servericons.xml"),
    Asset("IMAGE", "images/servericons.tex"),

    Asset("ATLAS", "images/npcchatflairs.xml"),
    Asset("IMAGE", "images/npcchatflairs.tex"),

    Asset("ATLAS", "images/balatro.xml"),
    Asset("IMAGE", "images/balatro.tex"),

    -- Loading screen
    Asset("ATLAS", "images/loading_screen.xml"),
    Asset("IMAGE", "images/loading_screen.tex"),
    Asset("ATLAS", "images/loading_screen_icons.xml"),
    Asset("IMAGE", "images/loading_screen_icons.tex"),

    --Wardrobe previewing
    Asset("ANIM", "anim/player_ghost_withhat.zip"),
    Asset("ANIM", "anim/werebeaver_basic.zip"),
    Asset("ANIM", "anim/weremoose_basic.zip"),
    Asset("ANIM", "anim/weregoose_basic.zip"),
    Asset("ANIM", "anim/player_basic.zip"),
    Asset("ANIM", "anim/player_idles.zip"),
    Asset("ANIM", "anim/player_idles_walter.zip"),
    Asset("ANIM", "anim/player_idles_ui.zip"),
    Asset("ANIM", "anim/player_idles_wolfgang.zip"),
    Asset("ANIM", "anim/player_idles_wolfgang_skinny.zip"),
    Asset("ANIM", "anim/player_idles_wolfgang_mighty.zip"),
    Asset("ANIM", "anim/player_idles_wickerbottom.zip"),

    Asset("DYNAMIC_ANIM", "anim/dynamic/body_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/hand_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/legs_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/feet_default1.zip"),
    Asset("PKGREF", "anim/dynamic/body_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/hand_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/legs_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/feet_default1.dyn"),

    Asset("DYNAMIC_ANIM", "anim/dynamic/beef_body_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/beef_horn_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/beef_head_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/beef_tail_default1.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/beef_feet_default1.zip"),
    Asset("PKGREF", "anim/dynamic/beef_body_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/beef_horn_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/beef_head_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/beef_tail_default1.dyn"),
    Asset("PKGREF", "anim/dynamic/beef_feet_default1.dyn"),


    Asset("ANIM", "anim/beard.zip"),
    Asset("ANIM", "anim/beard_silk.zip"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/beard_default1.zip"),
    Asset("PKGREF", "anim/dynamic/beard_default1.dyn"),

    Asset("DYNAMIC_ANIM", "anim/dynamic/previous_skin.zip"),
    Asset("PKGREF", "anim/dynamic/previous_skin.dyn"),
    Asset("DYNAMIC_ANIM", "anim/dynamic/random_skin.zip"),
    Asset("PKGREF", "anim/dynamic/random_skin.dyn"),
}

require "fonts"
for i, font in ipairs( FONTS ) do
    table.insert( assets, Asset( "FONT", font.filename ) )
end

for _,char in ipairs(DST_CHARACTERLIST) do
    table.insert(assets, Asset("DYNAMIC_ATLAS", "bigportraits/"..char..".xml"))
    table.insert(assets, Asset("PKGREF", "bigportraits/"..char..".tex"))

    table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_"..char..".xml"))
    table.insert(assets, Asset("PKGREF", "images/names_"..char..".tex"))

    table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_gold_"..char..".xml"))
    table.insert(assets, Asset("PKGREF", "images/names_gold_"..char..".tex"))

    table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_gold_cn_"..char..".xml"))
    table.insert(assets, Asset("PKGREF", "images/names_gold_cn_"..char..".tex"))
end

-- For hermithouse.
table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_pearl.xml"))
table.insert(assets, Asset("PKGREF", "images/names_pearl.tex"))
table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_gold_pearl.xml"))
table.insert(assets, Asset("PKGREF", "images/names_gold_pearl.tex"))
table.insert(assets, Asset("DYNAMIC_ATLAS", "images/names_gold_cn_pearl.xml"))
table.insert(assets, Asset("PKGREF", "images/names_gold_cn_pearl.tex"))

--Skin assets
for _, skin_asset in pairs(require("skin_assets")) do
    table.insert(assets, skin_asset)
end

--random player face for new anim character button
table.insert(assets, Asset("DYNAMIC_ANIM", "anim/dynamic/random.zip"))
table.insert(assets, Asset("PKGREF", "anim/dynamic/random.dyn"))

-- cookbook HD images
local cooking = require("cooking")
for _, recipe_cat in pairs(cooking.cookbook_recipes) do
	for _, data in pairs(recipe_cat) do
        if not cooking.IsModCookerFood(data.name) then
            table.insert(assets, Asset("DYNAMIC_ATLAS", "images/cookbook_"..data.name..".xml"))
            table.insert(assets, Asset("PKGREF", "images/cookbook_"..data.name..".tex"))
        end
	end
end

if QUAGMIRE_USE_KLUMP then
    --Add the custom quagmire recipe images
    for _,file in pairs(require("klump_files")) do
        local klump_file = string.gsub(file, "klump/", "")
        if klump_file:find(".tex") and klump_file:find("_hires") then --crappy assumption for now that _hires .tex klump files have a matching atlas that we need to load
            local xml_file = string.gsub(klump_file, ".tex", ".xml")
            table.insert(assets, Asset("DYNAMIC_ATLAS", xml_file)) --global because the recipe book is used in the frontend and backend
        end
    end
end

return Prefab("global", function() end, assets)
